#!/bin/bash
MODEL_PATH=$1
if [ -z "$2" ]; then
    overwrite=False
else
    overwrite=$2
fi




# if qwenvl in model path, pass
MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
    echo "qwen-vl in model path"
    exit 0 
fi
question_file=<DATA_FOLDER>/UNK-VQA/val_k_minus_llava_remove_ans_type2.llava_eval.jsonl
image_folder="<DATA_FOLDER>/UNK-VQA"
answer_file="${MODEL_PATH}/unk_vqa_public_val_k_minus_llava_remove_ans_type2/answers/merge.jsonl"
# Setting the base python command
python_cmd="python -m llava.eval.model_vqa_loader --model-path ${MODEL_PATH} --question-file ${question_file} --image-folder ${image_folder} --answers-file ${answer_file} --temperature 0 --conv-mode vicuna_v1"

# Append --overwrite if overwrite is True
if [ "$overwrite" = "True" ]; then
    python_cmd="$python_cmd --overwrite"
fi

echo "python_cmd: ${python_cmd}"
# Execute the command
$python_cmd

